pro contour_test
 
   restore, 'contour_data.sav'
   
   levels = [2,5,10,15,20,25,30,35,40,50,60,75,100,150,200,300]
   
   c_levels = bytarr(N_Elements(levels))
   for j = 0, N_Elements(levels)-1 do begin
      c_levels[j] = 240 + byte(j)
   endfor
   
   displaysize = [1000,750]
   
;--------------------------------------------------------------------------------------------
;+
; Loads the MOST colortable
;--------------------------------------------------------------------------------------------
   tvlct,r2,g2,b2,/get
     r2 = congrid(r2,239)
     g2 = congrid(g2,239)
     b2 = congrid(b2,239)

     loadct, 12, /silent
     tvlct,r3,g3,b3,/get

     r2 = [r2, Replicate(0B,17)]
     g2 = [g2, Replicate(0B,17)]
     b2 = [b2, Replicate(0B,17)]

     ; adjust the lowest color
     r2[240]=255 & g2[240]=205 & b2[240]=33
     ; copy the rgb from colortable 12 to higher slots in r2g2b2
     For i = 1,14 do begin
        r2[240+i] = r3[16*i]
        g2[240+i] = g3[16*i]
        b2[240+i] = b3[16*i]
     Endfor
     ; adjust the 226-240 colors
     r2[255] = 244 & g2[255] = 172 & b2[255] = 158

     tvlct,r2,g2,b2
   
   start = SYSTIME(/SECONDS)
   
   contour,MOST_VALS,most_lons,most_lats, levels=levels,C_color=c_levels,c_labels = 0,/cell_fill
   
   elapsed_time = SYSTIME(/SECONDS) - start

print, "Contour Pro time: ", elapsed_time
   
end